/*
 * Decompiled with CFR 0.152.
 */
package propositional;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import propositional.DisjunktivnaFormaZaLS;
import propositional.FaktorExpected;
import propositional.Pocetak;
import propositional.ZatvoriZagradu;

class Calc
extends JFrame
implements ActionListener {
    public static final char NEGACIJA_CHAR = '\u00ac';
    public static final char LIJEVA_ZAGRADA = '(';
    public static final char P_CHAR = 'P';
    public static final char Q_CHAR = 'Q';
    public static final char R_CHAR = 'R';
    static ArrayList propozicVarijable = new ArrayList();
    public static final char AND_CHAR = '\u22c0';
    public static final char OR_CHAR = '\u22c1';
    public static final char POVLACI_CHAR = '\u21d2';
    public static final char AKKO_CHAR = '\u21d4';
    static ArrayList binarniVeznici;
    static JLabel display;
    static JButton backSpace;
    static JButton clear;
    static JButton negacija;
    static JButton lijevaZagrada;
    static JButton desnaZagrada;
    static JButton PButton;
    static JButton QButton;
    static JButton RButton;
    static JButton and;
    static JButton or;
    static JButton povlaci;
    static JButton akko;
    static JButton negirajFormulu;
    static JButton enter;
    static int brojNezatvorenihZagrada;
    static JButton[][] matricaUnosa;
    static JPanel calculatorPanel;
    static JPanel interpretacijePanel;
    static JPanel stablaPanel;

    public Calc() {
        super("SIMPLE TREE \u2013 Propositional Logic Calculator");
        this.getContentPane().setLayout(new GridLayout(1, 2));
        GridBagLayout calculatorPanelGBLayout = new GridBagLayout();
        calculatorPanel = new JPanel();
        calculatorPanel.setLayout(calculatorPanelGBLayout);
        GridBagConstraints gbcDisplayPanel = new GridBagConstraints();
        gbcDisplayPanel.gridwidth = 3;
        gbcDisplayPanel.gridheight = 1;
        gbcDisplayPanel.fill = 2;
        gbcDisplayPanel.weighty = 0.1;
        JPanel displayPanel = new JPanel(new FlowLayout(0));
        displayPanel.setBackground(Color.yellow);
        displayPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        display = new JLabel(" ");
        displayPanel.add(display);
        calculatorPanelGBLayout.setConstraints(displayPanel, gbcDisplayPanel);
        calculatorPanel.add(displayPanel);
        GridBagConstraints gbcKeyPanel = new GridBagConstraints();
        gbcKeyPanel.gridx = 0;
        gbcKeyPanel.gridy = 1;
        gbcKeyPanel.gridwidth = 1;
        gbcKeyPanel.gridheight = 1;
        gbcKeyPanel.fill = 1;
        gbcKeyPanel.weighty = 0.1;
        JPanel keysPanel = new JPanel(new GridLayout(5, 3));
        JButton keys = new JButton("KEYS");
        keys.setFont(new Font("Times Roman", 1, 25));
        keys.setForeground(Color.blue);
        keysPanel.add(keys);
        backSpace = new JButton("BACKSPACE");
        backSpace.setFont(new Font("Times Roman", 1, 12));
        backSpace.setForeground(Color.yellow);
        backSpace.addActionListener(this);
        keysPanel.add(backSpace);
        clear = new JButton("CLEAR");
        clear.setFont(new Font("Times Roman", 1, 15));
        clear.setForeground(Color.yellow);
        clear.addActionListener(this);
        keysPanel.add(clear);
        negacija = new JButton(new Character('\u00ac').toString());
        negacija.addActionListener(this);
        keysPanel.add(negacija);
        lijevaZagrada = new JButton(new Character('(').toString());
        lijevaZagrada.addActionListener(this);
        keysPanel.add(lijevaZagrada);
        desnaZagrada = new JButton(")");
        desnaZagrada.addActionListener(this);
        keysPanel.add(desnaZagrada);
        PButton = new JButton(new Character('P').toString());
        PButton.addActionListener(this);
        keysPanel.add(PButton);
        QButton = new JButton(new Character('Q').toString());
        QButton.addActionListener(this);
        keysPanel.add(QButton);
        RButton = new JButton(new Character('R').toString());
        RButton.addActionListener(this);
        keysPanel.add(RButton);
        and = new JButton(new Character('\u22c0').toString());
        and.addActionListener(this);
        keysPanel.add(and);
        or = new JButton(new Character('\u22c1').toString());
        or.addActionListener(this);
        keysPanel.add(or);
        negirajFormulu = new JButton(new Character('\u00ac').toString() + " ( FORMULA )");
        negirajFormulu.setFont(new Font("Times Roman", 1, 12));
        negirajFormulu.setForeground(Color.yellow);
        negirajFormulu.addActionListener(this);
        keysPanel.add(negirajFormulu);
        povlaci = new JButton(new Character('\u21d2').toString());
        povlaci.addActionListener(this);
        keysPanel.add(povlaci);
        akko = new JButton(new Character('\u21d4').toString());
        akko.addActionListener(this);
        keysPanel.add(akko);
        enter = new JButton(" ENTER");
        enter.setFont(new Font("Times Roman", 1, 20));
        enter.setForeground(Color.yellow);
        enter.setBorder(BorderFactory.createLineBorder(Color.yellow, 2));
        enter.addActionListener(this);
        keysPanel.add(enter);
        calculatorPanelGBLayout.setConstraints(keysPanel, gbcKeyPanel);
        calculatorPanel.add(keysPanel);
        GridBagConstraints gbcInterpretacijePanel = new GridBagConstraints();
        gbcInterpretacijePanel.gridx = 3;
        gbcInterpretacijePanel.gridy = 0;
        gbcInterpretacijePanel.gridwidth = 1;
        gbcInterpretacijePanel.gridheight = 6;
        gbcInterpretacijePanel.fill = 1;
        interpretacijePanel = new JPanel(new GridLayout(10, 1));
        interpretacijePanel.setBorder(BorderFactory.createLineBorder(Color.blue, 1));
        JButton result = new JButton("RESULT :");
        result.setFont(new Font("Times Roman", 1, 16));
        result.setForeground(Color.yellow);
        result.setBackground(Color.blue);
        interpretacijePanel.add(result);
        for (int i = 1; i < 10; ++i) {
            interpretacijePanel.add(new JButton(""));
        }
        calculatorPanelGBLayout.setConstraints(interpretacijePanel, gbcInterpretacijePanel);
        calculatorPanel.add(interpretacijePanel);
        this.getContentPane().add(calculatorPanel);
        stablaPanel = new JPanel(new GridLayout(1, 2));
        stablaPanel.add(new JLabel("FORMULA", 0));
        stablaPanel.add(new JLabel("glavni test", 0));
        this.getContentPane().add(stablaPanel);
        this.setDefaultCloseOperation(3);
        this.pack();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameDim = this.getSize();
        this.setLocation(((int)screenDim.getWidth() - (int)frameDim.getWidth()) / 2, ((int)screenDim.getHeight() - (int)frameDim.getHeight()) / 2);
        this.show();
        brojNezatvorenihZagrada = 0;
        matricaUnosa = new JButton[][]{{null, backSpace, clear}, {negacija, lijevaZagrada, desnaZagrada}, {PButton, QButton, RButton}, {and, or, negirajFormulu}, {povlaci, akko, enter}};
        Calc.osvijetliKorakUnosa("pocetak");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        Object action = event.getSource();
        if (action.equals(enter)) {
            for (int i = 1; i < 10; ++i) {
                JButton gumb = (JButton)interpretacijePanel.getComponent(i);
                gumb.setText("");
                gumb.setBackground(new Color(204, 204, 204));
            }
            stablaPanel.removeAll();
            try {
                DisjunktivnaFormaZaLS.disjunktivnaFormaZaLS();
            }
            catch (FaktorExpected exception) {
                Calc.osvijetliKorakUnosa("faktor expected");
            }
            catch (Pocetak exception) {
                Calc.osvijetliKorakUnosa("pocetak");
            }
            catch (ZatvoriZagradu exception) {
                desnaZagrada.setBackground(Color.yellow);
            }
            finally {
                if (display.getText().length() > 1 && DisjunktivnaFormaZaLS.i + 1 < display.getText().length()) {
                    int i = DisjunktivnaFormaZaLS.i + 1;
                    if (i + 1 < display.getText().length()) {
                        String smece = display.getText().substring(i);
                        for (int j = 0; j < smece.length(); ++j) {
                            if (smece.charAt(j) == '(') {
                                --brojNezatvorenihZagrada;
                            }
                            if (smece.charAt(j) != ')') continue;
                            ++brojNezatvorenihZagrada;
                        }
                    }
                    char trik = display.getText().charAt(i);
                    display.setText(display.getText().substring(0, i) + trik);
                    if (trik == '(') {
                        ++brojNezatvorenihZagrada;
                    }
                    if (trik == ')') {
                        --brojNezatvorenihZagrada;
                    }
                    action = backSpace;
                }
                switch (stablaPanel.getComponentCount()) {
                    case 0: {
                        stablaPanel.add(new JLabel("FORMULA", 0));
                        stablaPanel.add(new JLabel("glavni test", 0));
                        break;
                    }
                    case 1: {
                        stablaPanel.add(new JLabel("glavni test", 0));
                    }
                }
            }
        }
        if (action.equals(backSpace)) {
            int duljina = display.getText().length();
            if (duljina == 2) {
                action = clear;
            }
            if (duljina > 2) {
                if (display.getText().charAt(duljina - 1) == '(') {
                    --brojNezatvorenihZagrada;
                }
                if (display.getText().charAt(duljina - 1) == ')') {
                    ++brojNezatvorenihZagrada;
                }
                switch (display.getText().charAt(duljina - 2)) {
                    case '\u00ac': {
                        action = negacija;
                        break;
                    }
                    case '(': {
                        action = lijevaZagrada;
                        --brojNezatvorenihZagrada;
                        break;
                    }
                    case ')': {
                        action = desnaZagrada;
                        ++brojNezatvorenihZagrada;
                        break;
                    }
                    case 'P': {
                        action = PButton;
                        break;
                    }
                    case 'Q': {
                        action = QButton;
                        break;
                    }
                    case 'R': {
                        action = RButton;
                        break;
                    }
                    case '\u22c0': {
                        action = and;
                        break;
                    }
                    case '\u22c1': {
                        action = or;
                        break;
                    }
                    case '\u21d2': {
                        action = povlaci;
                        break;
                    }
                    case '\u21d4': {
                        action = akko;
                    }
                }
                display.setText(display.getText().substring(0, duljina - 2));
            }
        }
        if (action.equals(clear)) {
            display.setText(" ");
            for (int i = 1; i < 10; ++i) {
                JButton gumb = (JButton)interpretacijePanel.getComponent(i);
                gumb.setText("");
                gumb.setBackground(new Color(204, 204, 204));
            }
            stablaPanel.removeAll();
            stablaPanel.add(new JLabel("FORMULA", 0));
            stablaPanel.add(new JLabel("glavni test", 0));
            brojNezatvorenihZagrada = 0;
            Calc.osvijetliKorakUnosa("pocetak");
        }
        if (action.equals(negirajFormulu)) {
            display.setText(" " + new Character('\u00ac').toString() + new Character('(').toString() + display.getText().substring(1) + new Character(')').toString());
        }
        if (action.equals(negacija)) {
            display.setText(display.getText() + negacija.getText());
            Calc.osvijetliKorakUnosa("faktor expected");
        }
        if (action.equals(lijevaZagrada)) {
            display.setText(display.getText() + lijevaZagrada.getText());
            ++brojNezatvorenihZagrada;
            Calc.osvijetliKorakUnosa("faktor expected");
        }
        if (action.equals(desnaZagrada)) {
            display.setText(display.getText() + desnaZagrada.getText());
            --brojNezatvorenihZagrada;
            Calc.osvijetliKorakUnosa("binarni veznik expected");
        }
        if (action.equals(PButton)) {
            display.setText(display.getText() + PButton.getText());
            Calc.osvijetliKorakUnosa("binarni veznik expected");
        }
        if (action.equals(QButton)) {
            display.setText(display.getText() + QButton.getText());
            Calc.osvijetliKorakUnosa("binarni veznik expected");
        }
        if (action.equals(RButton)) {
            display.setText(display.getText() + RButton.getText());
            Calc.osvijetliKorakUnosa("binarni veznik expected");
        }
        if (action.equals(and)) {
            display.setText(display.getText() + and.getText());
            Calc.osvijetliKorakUnosa("faktor expected");
        }
        if (action.equals(or)) {
            display.setText(display.getText() + or.getText());
            Calc.osvijetliKorakUnosa("faktor expected");
        }
        if (action.equals(povlaci)) {
            display.setText(display.getText() + povlaci.getText());
            Calc.osvijetliKorakUnosa("faktor expected");
        }
        if (action.equals(akko)) {
            display.setText(display.getText() + akko.getText());
            Calc.osvijetliKorakUnosa("faktor expected");
        }
    }

    public static void main(String[] args) throws Exception {
        new Calc();
    }

    public static void osvijetliKorakUnosa(String ulaznoStanje) {
        for (int i = 0; i < matricaUnosa.length; ++i) {
            for (int j = 0; j < matricaUnosa[0].length; ++j) {
                if (matricaUnosa[i][j] == null) continue;
                matricaUnosa[i][j].setBackground(Color.LIGHT_GRAY);
            }
        }
        if (ulaznoStanje.equals("pocetak")) {
            matricaUnosa[1][0].setBackground(Color.blue);
            matricaUnosa[1][1].setBackground(Color.blue);
            matricaUnosa[2][0].setBackground(Color.blue);
            matricaUnosa[2][1].setBackground(Color.blue);
            matricaUnosa[2][2].setBackground(Color.blue);
        }
        if (ulaznoStanje.equals("faktor expected")) {
            matricaUnosa[0][1].setBackground(Color.blue);
            matricaUnosa[0][2].setBackground(Color.blue);
            matricaUnosa[1][0].setBackground(Color.blue);
            matricaUnosa[1][1].setBackground(Color.blue);
            matricaUnosa[2][0].setBackground(Color.blue);
            matricaUnosa[2][1].setBackground(Color.blue);
            matricaUnosa[2][2].setBackground(Color.blue);
        }
        if (ulaznoStanje.equals("binarni veznik expected")) {
            matricaUnosa[0][1].setBackground(Color.blue);
            matricaUnosa[0][2].setBackground(Color.blue);
            if (brojNezatvorenihZagrada > 0) {
                matricaUnosa[1][2].setBackground(Color.blue);
            }
            matricaUnosa[3][0].setBackground(Color.blue);
            matricaUnosa[3][1].setBackground(Color.blue);
            matricaUnosa[3][2].setBackground(Color.blue);
            matricaUnosa[4][0].setBackground(Color.blue);
            matricaUnosa[4][1].setBackground(Color.blue);
            matricaUnosa[4][2].setBackground(Color.blue);
        }
    }

    static {
        propozicVarijable.add(new Character('\u00ac'));
        propozicVarijable.add(new Character('('));
        propozicVarijable.add(new Character('P'));
        propozicVarijable.add(new Character('Q'));
        propozicVarijable.add(new Character('R'));
        binarniVeznici = new ArrayList();
        binarniVeznici.add(new Character('\u22c0'));
        binarniVeznici.add(new Character('\u22c1'));
        binarniVeznici.add(new Character('\u21d2'));
        binarniVeznici.add(new Character('\u21d4'));
    }
}

